/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.collect;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.Nullable;
import org.python.google.common.base.Equivalence;
import org.python.google.common.base.Function;
import org.python.google.common.base.Preconditions;
import org.python.google.common.collect.AsynchronousComputationException;
import org.python.google.common.collect.ComputationException;
import org.python.google.common.collect.CustomConcurrentHashMap;
import org.python.google.common.collect.MapEvictionListener;
import org.python.google.common.collect.MapMaker;
import org.python.google.common.collect.NullOutputException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComputingConcurrentHashMap<K, V>
extends CustomConcurrentHashMap<K, V>
implements MapMaker.Cache<K, V> {
    final Function<? super K, ? extends V> computingFunction;
    private static final long serialVersionUID = 1L;

    ComputingConcurrentHashMap(MapMaker mapMaker, Function<? super K, ? extends V> function) {
        super(mapMaker);
        this.computingFunction = Preconditions.checkNotNull(function);
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V apply(K k) {
        Preconditions.checkNotNull(k);
        int n = this.hash(k);
        CustomConcurrentHashMap.Segment segment = this.segmentFor(n);
        block12: while (true) {
            Object object;
            boolean bl;
            CustomConcurrentHashMap.ReferenceEntry referenceEntry;
            if ((referenceEntry = segment.getEntry(k, n)) == null) {
                int n2;
                bl = false;
                segment.lock();
                try {
                    if (this.expires) {
                        segment.expireEntries();
                    }
                    if ((referenceEntry = segment.getEntry(k, n)) == null) {
                        bl = true;
                        n2 = segment.count;
                        if (n2++ > segment.threshold) {
                            segment.expand();
                        }
                        object = segment.table;
                        int n3 = n & ((AtomicReferenceArray)object).length() - 1;
                        CustomConcurrentHashMap.ReferenceEntry referenceEntry2 = (CustomConcurrentHashMap.ReferenceEntry)((AtomicReferenceArray)object).get(n3);
                        ++segment.modCount;
                        referenceEntry = this.entryFactory.newEntry(this, k, n, referenceEntry2);
                        ((AtomicReferenceArray)object).set(n3, referenceEntry);
                        segment.count = n2;
                    }
                }
                finally {
                    segment.unlock();
                }
                if (bl) {
                    n2 = 0;
                    try {
                        object = this.compute(segment, k, referenceEntry);
                        Preconditions.checkNotNull(object, "compute() returned null unexpectedly");
                        n2 = 1;
                        Object object2 = object;
                        return (V)object2;
                    }
                    finally {
                        if (n2 == 0) {
                            segment.removeEntry(referenceEntry, n);
                        }
                    }
                }
            }
            bl = false;
            while (true) {
                try {
                    Object v = this.waitForValue(referenceEntry);
                    if (v == null) {
                        segment.removeEntry(referenceEntry, n);
                        continue block12;
                    }
                    object = v;
                    return (V)object;
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    continue;
                }
                break;
            }
            finally {
                if (!bl) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setValueReference(CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry, CustomConcurrentHashMap.ValueReference<K, V> valueReference) {
        boolean bl = referenceEntry.getValueReference() == UNSET;
        referenceEntry.setValueReference(valueReference);
        if (bl) {
            CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry2 = referenceEntry;
            synchronized (referenceEntry2) {
                referenceEntry.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V waitForValue(CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry) throws InterruptedException {
        CustomConcurrentHashMap.ValueReference<K, V> valueReference = referenceEntry.getValueReference();
        if (valueReference == UNSET) {
            CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry2 = referenceEntry;
            synchronized (referenceEntry2) {
                while ((valueReference = referenceEntry.getValueReference()) == UNSET) {
                    referenceEntry.wait();
                }
            }
        }
        return valueReference.waitForValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V compute(CustomConcurrentHashMap.Segment segment, K k, CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry) {
        V v;
        try {
            v = this.computingFunction.apply(k);
        }
        catch (ComputationException computationException) {
            this.setValueReference(referenceEntry, new ComputationExceptionReference(computationException.getCause()));
            throw computationException;
        }
        catch (Throwable throwable) {
            this.setValueReference(referenceEntry, new ComputationExceptionReference(throwable));
            throw new ComputationException(throwable);
        }
        if (v == null) {
            String string = this.computingFunction + " returned null for key " + k + ".";
            this.setValueReference(referenceEntry, new NullOutputExceptionReference(string));
            throw new NullOutputException(string);
        }
        if (this.expires) {
            segment.lock();
            try {
                segment.setValue(referenceEntry, v, true);
            }
            finally {
                segment.unlock();
            }
        } else {
            segment.setValue(referenceEntry, v, true);
        }
        return v;
    }

    @Override
    CustomConcurrentHashMap.ReferenceEntry<K, V> copyEntry(CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry, CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry2) {
        CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry3 = this.entryFactory.copyEntry(this, referenceEntry, referenceEntry2);
        CustomConcurrentHashMap.ValueReference<K, V> valueReference = referenceEntry.getValueReference();
        if (valueReference == UNSET) {
            referenceEntry3.setValueReference(new FutureValueReference(referenceEntry, referenceEntry3));
        } else {
            referenceEntry3.setValueReference(valueReference.copyFor(referenceEntry3));
        }
        return referenceEntry3;
    }

    @Override
    Object writeReplace() {
        return new ComputingSerializationProxy<K, V>(this.keyStrength, this.valueStrength, this.keyEquivalence, this.valueEquivalence, this.expirationNanos, this.maximumSize, this.concurrencyLevel, this.evictionListener, this, this.computingFunction);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComputationExceptionReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final Throwable t;

        ComputationExceptionReference(Throwable throwable) {
            this.t = throwable;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry) {
            return this;
        }

        @Override
        public V waitForValue() {
            throw new AsynchronousComputationException(this.t);
        }

        @Override
        public void clear() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComputingSerializationProxy<K, V>
    extends CustomConcurrentHashMap.AbstractSerializationProxy<K, V> {
        final Function<? super K, ? extends V> computingFunction;
        transient MapMaker.Cache<K, V> cache;
        private static final long serialVersionUID = 1L;

        ComputingSerializationProxy(CustomConcurrentHashMap.Strength strength, CustomConcurrentHashMap.Strength strength2, Equivalence<Object> equivalence, Equivalence<Object> equivalence2, long l, int n, int n2, MapEvictionListener<? super K, ? super V> mapEvictionListener, ConcurrentMap<K, V> concurrentMap, Function<? super K, ? extends V> function) {
            super(strength, strength2, equivalence, equivalence2, l, n, n2, mapEvictionListener, concurrentMap);
            this.computingFunction = function;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            this.writeMapTo(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            MapMaker mapMaker = this.readMapMaker(objectInputStream);
            this.cache = mapMaker.makeCache(this.computingFunction);
            this.delegate = this.cache.asMap();
            this.readEntries(objectInputStream);
        }

        Object readResolve() {
            return this.cache;
        }

        public ConcurrentMap<K, V> asMap() {
            return this.delegate;
        }

        public V apply(@Nullable K k) {
            return (V)this.cache.apply(k);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FutureValueReference
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final CustomConcurrentHashMap.ReferenceEntry<K, V> original;
        final CustomConcurrentHashMap.ReferenceEntry<K, V> newEntry;

        FutureValueReference(CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry, CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry2) {
            this.original = referenceEntry;
            this.newEntry = referenceEntry2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get() {
            boolean bl = false;
            try {
                Object v = this.original.getValueReference().get();
                bl = true;
                Object v2 = v;
                return v2;
            }
            finally {
                if (!bl) {
                    this.removeEntry();
                }
            }
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry) {
            return new FutureValueReference(this.original, referenceEntry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V waitForValue() throws InterruptedException {
            boolean bl = false;
            try {
                Object v = ComputingConcurrentHashMap.this.waitForValue(this.original);
                bl = true;
                Object v2 = v;
                return v2;
            }
            finally {
                if (!bl) {
                    this.removeEntry();
                }
            }
        }

        @Override
        public void clear() {
            this.original.getValueReference().clear();
        }

        void removeEntry() {
            ComputingConcurrentHashMap.this.removeEntry(this.newEntry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullOutputExceptionReference<K, V>
    implements CustomConcurrentHashMap.ValueReference<K, V> {
        final String message;

        NullOutputExceptionReference(String string) {
            this.message = string;
        }

        @Override
        public V get() {
            return null;
        }

        @Override
        public CustomConcurrentHashMap.ValueReference<K, V> copyFor(CustomConcurrentHashMap.ReferenceEntry<K, V> referenceEntry) {
            return this;
        }

        @Override
        public V waitForValue() {
            throw new NullOutputException(this.message);
        }

        @Override
        public void clear() {
        }
    }
}

